'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Created by jack on 2017/8/16.
 */

var SCENE = function () {
    function SCENE() {
        _classCallCheck(this, SCENE);

        var dpi = window.devicePixelRatio;

        this.width = window.innerWidth * dpi;
        this.height = window.innerHeight * dpi;

        this.canvas = this.createCanvas();
        this.ctx = this.canvas.getContext('2d');
        this.bg = null;

        this.event();

        this.init();
    }

    _createClass(SCENE, [{
        key: 'createCanvas',
        value: function createCanvas(w, h) {
            var canvas = document.createElement('canvas');
            canvas.width = w || this.width;
            canvas.height = h || this.height;
            return canvas;
        }
    }, {
        key: 'event',
        value: function event() {
            var _this = this;

            var canvas = this.canvas,
                dpi = window.devicePixelRatio;

            $(window).resize(function () {
                var width = window.innerWidth * dpi,
                    height = window.innerHeight * dpi;
                _this.width = width;
                _this.height = height;
                canvas.width = width;
                canvas.height = height;
                canvas.style.width = window.innerWidth + "px";
                canvas.style.height = window.innerHeight + "px";
                _this.switch(_this.bg, true);
            });
        }
    }, {
        key: 'init',
        value: function init() {
            var canvas = this.canvas;
            canvas.width = this.width;
            canvas.height = this.height;
            canvas.style.width = window.innerWidth + "px";
            canvas.style.height = window.innerHeight + "px";
            $(canvas).css({
                position: 'fixed',
                left: 0,
                top: 0,
                zIndex: '-1'
            });
            document.body.appendChild(canvas);
        }
    }, {
        key: 'background',
        value: function background(img) {
            if (!img) return Promise.resolve();
            var pms = this.switch(img);
            this.bg = img;
            return pms; //返回一个promise对象
        }

        /**
         *
         * @param img
         * @param translate 不需要缓动 true
         * @return {*}
         */

    }, {
        key: 'switch',
        value: function _switch(img, translate) {
            var ctx = this.ctx,
                v = { op: 0 },
                width = this.width,
                height = this.height,
                data = this.getData(img, width, height),
                _resolve = null;
            var psm = new Promise(function (resolve, reject) {
                _resolve = resolve;
            });
            if (translate) {
                ctx.drawImage(img, data.x, 0, data.width, data.height, 0, 0, width, height);
            } else {
                TweenMax.to(v, 0.3, {
                    op: 1,
                    onUpdate: function onUpdate() {
                        ctx.globalAlpha = v.op;
                        ctx.drawImage(img, data.x, 0, data.width, data.height, 0, 0, width, height);
                    },
                    onComplete: function onComplete() {
                        _resolve();
                    }
                });
            }
            return translate ? Promise.resolve() : psm;
        }
    }, {
        key: 'getData',
        value: function getData(img, w, h) {
            var _w = img.width,
                _h = img.height,
                bl = w / h,
                //比例
            _bl = _w / _h,
                //比例
            width = null,
                height = null,
                x = null; //倍数
            if (bl < _bl) {
                width = bl * _h;
                height = _h;
                x = (_w - width) / 2;
            } else {
                width = _w;
                height = _w / bl;
                x = 0;
            }
            return {
                width: width,
                height: height,
                x: x
            };
        }
    }, {
        key: 'clear',
        value: function clear() {
            var ctx = this.ctx,
                width = this.canvas.width,
                height = this.canvas.height;
            ctx.clearRect(0, 0, width, height);
        }
    }]);

    return SCENE;
}();

var E_ANIMATE = function () {
    function E_ANIMATE(canvas) {
        _classCallCheck(this, E_ANIMATE);

        // this.canvas = $(selector);
        // this.canvas = this.createCanvas(null, null);
        this.canvas = canvas;
        this.ctx = this.canvas.getContext('2d');
        this.status = true;
        this.delay = 15;
        this.index = 0;
        this.paused = false;
        this.repeat = true;
        this.request = null;

        this.image_lib = {
            1000: {
                url: ['/Public/img/animate/gif/1.png', '/Public/img/animate/gif/2.png', '/Public/img/animate/gif/3.png', '/Public/img/animate/gif/5.png', '/Public/img/animate/gif/6.png', '/Public/img/animate/gif/7.png', '/Public/img/animate/gif/8.png', '/Public/img/animate/gif/8.png', '/Public/img/animate/gif/10.png']
            }
        };

        // this.tempCanvas = this.createCanvas();

        // this.event();
        // this.loadImages().then(() => {
        //     this.play(this.repeat);
        // })
    }

    _createClass(E_ANIMATE, [{
        key: 'event',
        value: function event() {
            var _this2 = this;

            if (!E_ANIMATE.isBindEvent) {
                E_ANIMATE.isBindEvent = true;
                this.canvas.addEventListener('click', function () {
                    if (_this2.paused) {
                        _this2.restart();
                    } else {
                        _this2.pause();
                    }
                });
            }
        }
    }, {
        key: 'preLoad',
        value: function preLoad(id) {
            var lib = this.image_lib,
                list = lib[id];
            return list ? this.loadImages(list) : Promise.resolve();
        }
    }, {
        key: 'loadImage',
        value: function loadImage(img) {
            return new Promise(function (resolve, reject) {
                img.addEventListener('load', function () {
                    resolve();
                });
            });
        }
    }, {
        key: 'loadImages',
        value: function loadImages(list) {
            var _this3 = this;

            list.img = [];
            return Promise.all(list.url.map(function (url) {
                var image = new Image();
                list.img.push(image);
                image.src = url;
                return _this3.loadImage(image);
            }));
        }
    }, {
        key: 'pause',
        value: function pause() {
            this.paused = true;
        }
    }, {
        key: 'restart',
        value: function restart() {
            this.paused = false;
            this.play(this.repeat);
        }
    }, {
        key: 'play',
        value: function play(id, times, repeat) {
            var that = this,
                animate_lib = this.image_lib[id],
                images = animate_lib ? animate_lib.img : null,
                delay = this.delay,
                index = 0,
                _resolve = null;

            var pms = new Promise(function (resolve, reject) {
                _resolve = resolve;
            });

            function _draw() {
                // let img = images[index].img;
                var img = images[index];
                that.draw(img);
                if (index >= images.length - 1) {
                    if (repeat) {
                        index = 0;
                    } else if (times) {
                        times--;
                        index = 0;
                    } else {
                        cancelAnimationFrame(that.request);
                        _resolve();
                        return;
                    }
                } else {
                    index++;
                }
                if (that.paused) {
                    cancelAnimationFrame(that.request);
                    return;
                }
                if (delay) {
                    setTimeout(function () {
                        requestAnimationFrame(_draw);
                    }, delay);
                } else {
                    that.request = requestAnimationFrame(_draw);
                }
            }

            images && _draw();

            return images ? pms : Promise.resolve();
        }
    }, {
        key: 'draw',
        value: function draw(img) {
            var ctx = this.ctx;
            ctx.drawImage(img, 0, 0, img.width, img.height, 0, 0, $('body').width(), $(window).height());
        }
    }]);

    return E_ANIMATE;
}();

E_ANIMATE.isBindEvent = false;